/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ForgottenModifier
extends NoLevelsModifier {
    private static final Component MINING_SPEED = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)new ResourceLocation("tcintegrations", "forgotten.mining_speed")));
    private static final Component ATTACK_INCREASE = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)new ResourceLocation("tcintegrations", "forgotten.attack_increase")));

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            LivingEntity attacker = context.getAttacker();
            BlockState state = attacker.f_19853_.m_8055_(attacker.m_20097_());
            if (tool.hasTag(TinkerTags.Items.MELEE) && this.isUndergarden(state, attacker)) {
                return damage * 1.5f;
            }
        }
        return damage;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        BlockState state = event.getState();
        if (tool.hasTag(TinkerTags.Items.HARVEST) && isEffective && state != null && this.isUndergarden(state, event.getEntityLiving())) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.5f);
        }
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        BlockState state;
        BlockState blockState = state = player != null ? player.f_19853_.m_8055_(player.m_20097_()) : null;
        if (state != null && this.isUndergarden(state, (LivingEntity)player)) {
            if (tool.hasTag(TinkerTags.Items.HARVEST)) {
                this.addPercentTooltip(MINING_SPEED, 0.5, tooltip);
            }
            if (tool.hasTag(TinkerTags.Items.MELEE)) {
                this.addPercentTooltip(ATTACK_INCREASE, 0.5, tooltip);
            }
        }
    }

    private boolean isUndergarden(BlockState state, LivingEntity livingEntity) {
        return state.m_60734_().getRegistryName().m_135827_().equals("undergarden") && livingEntity.m_6072_();
    }
}

